#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//Checkerboard Truchet 2Mod01.fsh   by  SnoopethDuckDuck  
//https://www.shadertoy.com/view/NdjBWt
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract
// start Image //
// start buffer //
#define pi 3.14159

#define thc(a,b) tanh(a*cos(b))/tanh(a)
#define ths(a,b) tanh(a*sin(b))/tanh(a)
#define sabs(x) sqrt(x*x+1e-2)
//#define sabs(x, k) sqrt(x*x+k)-0.1

#define Rot(a) mat2(cos(a), -sin(a), sin(a), cos(a))

float cc(float a, float b) {
    float f = thc(a, b);
    return sign(f) * pow(abs(f), 0.25);
}

float cs(float a, float b) {
    float f = ths(a, b);
    return sign(f) * pow(abs(f), 0.25);
}

vec3 pal(in float t, in vec3 a, in vec3 b, in vec3 c, in vec3 d) {
    return a + b*cos( 6.28318*(c*t+d) );
}

float h21(vec2 a) {
    return fract(sin(dot(a.xy, vec2(12.9898, 78.233))) * 43758.5453123);
}

float mlength(vec2 uv) {
    return max(abs(uv.x), abs(uv.y));
}

float mlength(vec3 uv) {
    return max(max(abs(uv.x), abs(uv.y)), abs(uv.z));
}

float smin(float a, float b) {
    float k = 0.12;
    float h = clamp(0.5 + 0.5 * (b-a) / k, 0.0, 1.0);
    return mix(b, a, h) - k * h * (1.0 - h);
}
//end buffer //
float h21 (vec2 uv, float sc) {
    uv = mod(uv, sc);
    return fract(sin(dot(uv, vec2(12.9898, 78.233)))*43758.5453123);
}

float line(vec2 uv, float width) {
    return max(-uv.y + width, abs(uv.x));
}

float curve(vec2 uv) {
    return abs(length(uv-0.5) - 0.5);
}

float shape(vec2 uv, vec4 h, float width) {
    if (h.x + h.y + h.z + h.w == 0.)
        return 0.;
         
    // center circle to round off line segments
    float d = length(uv);     
         
    // draw line segment from center to edge (-width offset for center circle)
    d = mix(d, min(d, line(uv,     width)), h.x);
    d = mix(d, min(d, line(uv.yx,  width)), h.y);
    d = mix(d, min(d, line(-uv,    width)), h.z);
    d = mix(d, min(d, line(-uv.yx, width)), h.w);
    
    // draw quarter circle between 2 edges
    d = mix(d, min(d, curve(vec2(uv.x, uv.y))),   h.x * h.y);
    d = mix(d, min(d, curve(vec2(uv.x, -uv.y))),  h.y * h.z);
    d = mix(d, min(d, curve(vec2(-uv.x, -uv.y))), h.z * h.w);
    d = mix(d, min(d, curve(vec2(-uv.x, uv.y))),  h.w * h.x);
    
    float k = 6./iResolution.y;
    return smoothstep(-k, k, -d + width);
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    vec2 uv = (fragCoord - 0.5 * iResolution.xy) / iResolution.y;
    vec2 ouv = uv;
    uv.x += 10. + 0.08 * iTime;          
    uv.y += 0.005 * thc(10., 3. * uv.x + 0.28 * iTime);
    
    float sc = 13.;         
    vec2 ipos = floor(sc * uv) + 0.;
    vec2 fpos = fract(sc * uv) - 0.5;
    
    float width = 0.3 + 0.15 * cc(0.5, 0.5 * h21(ipos) + .5 * uv.x + 0.8 * iTime);

    // arbitrary values - hash repetition, offset
    float rep = 302.; 
    float val = 0.01;   
    
    // Checkerboard pattern:
    // black cells choose edges for themselves + white cells
    // white cells look at black cells to find edges
    // construct pattern for cell based on edge configuration
    float s = 0.;
    vec4 r;
    vec4 h, h2, h3;
    if (mod(ipos.x + ipos.y, 2.) == 0.) {
        r = vec4(h21(ipos,            rep),  // up
                 h21(ipos + val,      rep),  // right
                 h21(ipos + 2. * val, rep),  // down
                 h21(ipos + 3. * val, rep)); // left ( I think* )
        
        h3 = step(r, vec4(0.6)), h2 = step(r, vec4(0.4)), h = step(r, vec4(0.2));   
        s = shape(fpos, h, width);
        s += 0.5 * (1.-s) * shape(fpos, h2, width);
        s += 0.25 * (1.-s) * shape(fpos, h3, width);
    } else {
        r = vec4(h21(ipos + vec2(0,1) + 2. * val, rep),  // up's down
                 h21(ipos + vec2(1,0) + 3. * val, rep),  // right's left
                 h21(ipos - vec2(0,1),            rep),  // down's up
                 h21(ipos - vec2(1,0) + val,      rep)); // left's right
        
        h3 = step(r, vec4(0.6)), h2 = step(r, vec4(0.4)), h = step(r, vec4(0.2));
        s = shape(fpos, h, width);
        s += 0.5 * (1.-s) * shape(fpos, h2, width);  
        s += 0.25 * (1.-s) * shape(fpos, h3, width);
    }
    
    vec3 e = vec3(1);
    // was using floor(h21() + iTime), width is a messy stand-in
    vec3 col = s * pal(-0.08 * floor(width * 4.) + 0.19 + 0.05 * (r.x + r.y + r.z + r.w), e, e, e, 0.42 * vec3(0,1,2)/3.);
    //col += (1.-s) * pal(0.5 + 0.23 * uv.y, e, e, e, 0.15 * vec3(0,1,2)/3.);
    //col *= 10. *(1.-s) * exp(-8. * length(ouv));
    col += (1.-s) * vec3(s,0,0.22) * (uv.y+0.5);
    
    fragColor = vec4(col,1.0);

//end Image //
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

